********************************************************************************
*Project: 			More Clarification, Less Item Nonresponse in Establishment Surveys? A Split-Ballot Experiment
*Author: 			Benjamin Küfner, Joseph W. Sakshaug, Stefan Zins
*Titel Do-File: 	Item Nonresponse in previous years
*Final Date: 		06.05.2021
********************************************************************************

////////////////////////////////////////////////////////////////////////////////
*1. Log-File and Dataset - CHECK
////////////////////////////////////////////////////////////////////////////////

*IAB-Stellenerhebung
global in_path "N:\Ablagen\D01700-IAB-Projekte\D01700-Stellenerhebung\Daten"
log using "${log_path}/nonresponse_previous_year.log", replace

use "${in_path}\IABSE-Q4-HauptZusatz-Greg_2015-2020.dta",clear
append using "${in_path}\IABSE-Q4-HauptZusatz-Greg_2010-2014.dta"
set more off
numlabel _all, add

////////////////////////////////////////////////////////////////////////////////
*2. Item Nonresponse Indicator - CHECK
////////////////////////////////////////////////////////////////////////////////
foreach var in zf7 zf5 zf6 zf4  {
replace `var'=.b if einst ==5 | einst ==. |einst ==6			// Falls der Filter greift
gen INR_`var' =0
recode INR_`var' (0=1) if `var' ==. 
replace INR_`var' =. if `var' ==.b
}

////////////////////////////////////////////////////////////////////////////////
*3. Analysis Item Nonresponse  - CHECK
////////////////////////////////////////////////////////////////////////////////
foreach var in zf7 zf5 zf6 zf4  {
di "ALL"
tab INR_`var' jahr, col row
di "P&P"
tab INR_`var' jahr if antwort ==1, col row
di "Web"
tab INR_`var' jahr if antwort ==2, col row 
}

////////////////////////////////////////////////////////////////////////////////
*4. Closing Section - Check
////////////////////////////////////////////////////////////////////////////////
log close
exit